<?php

/*
 * This file is part of the PHPExifTool package.
 *
 * (c) Alchemy <support@alchemy.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace PHPExiftool\Driver\Tag\RAF2;

use JMS\Serializer\Annotation\ExclusionPolicy;
use PHPExiftool\Driver\AbstractTag;

/**
 * @ExclusionPolicy("all")
 */
class RawImageFullSize extends AbstractTag
{

    protected $Id = 256;

    protected $Name = 'RawImageFullSize';

    protected $FullName = 'FujiFilm::RAF';

    protected $GroupName = 'RAF2';

    protected $g0 = 'RAF';

    protected $g1 = 'RAF';

    protected $g2 = 'Image';

    protected $Type = 'int16u';

    protected $Writable = false;

    protected $Description = 'Raw Image Full Size';

    protected $local_g1 = 'RAF2';

    protected $MaxLength = 2;

}
