/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;

public final class Remove
implements MovieTag {
    private static final String FORMAT = "Remove: { identifier=%d; layer=%d}";
    private int identifier;
    private int layer;

    public Remove(SWFDecoder coder) throws IOException {
        if ((coder.readUnsignedShort() & 0x3F) == 63) {
            coder.readInt();
        }
        this.identifier = coder.readUnsignedShort();
        this.layer = coder.readUnsignedShort();
    }

    public Remove(int uid, int level) {
        this.setIdentifier(uid);
        this.setLayer(level);
    }

    public Remove(Remove object) {
        this.identifier = object.identifier;
        this.layer = object.layer;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    public int getLayer() {
        return this.layer;
    }

    public void setLayer(int aLayer) {
        if (aLayer < 1 || aLayer > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, aLayer);
        }
        this.layer = aLayer;
    }

    @Override
    public Remove copy() {
        return new Remove(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier, this.layer);
    }

    @Override
    public int prepareToEncode(Context context) {
        return 6;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeShort(324);
        coder.writeShort(this.identifier);
        coder.writeShort(this.layer);
    }
}

