/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.sound;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import java.io.IOException;
import java.util.Arrays;

public final class SoundStreamBlock
implements MovieTag {
    private static final String FORMAT = "SoundStreamBlock: {sound=byte<%d> ...}";
    private byte[] sound;
    private transient int length;

    public SoundStreamBlock(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        this.sound = coder.readBytes(new byte[this.length]);
    }

    public SoundStreamBlock(byte[] bytes) {
        this.setSound(bytes);
    }

    public SoundStreamBlock(SoundStreamBlock object) {
        this.sound = object.sound;
    }

    public byte[] getSound() {
        return Arrays.copyOf(this.sound, this.sound.length);
    }

    public void setSound(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException();
        }
        this.sound = Arrays.copyOf(bytes, bytes.length);
    }

    @Override
    public SoundStreamBlock copy() {
        return new SoundStreamBlock(this);
    }

    public String toString() {
        return String.format(FORMAT, this.sound.length);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = this.sound.length;
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(1279);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x4C0 | this.length);
        }
        coder.mark();
        coder.writeBytes(this.sound);
        coder.check(this.length);
        coder.unmark();
    }
}

