/*
 * Decompiled with CFR 0.152.
 */
package com.hammurapi.jcapture;

import com.hammurapi.jcapture.FragmentImpl;
import com.hammurapi.jcapture.FrameImpl;
import com.hammurapi.jcapture.ImageToolTip;
import com.hammurapi.jcapture.MappedImage;
import com.hammurapi.jcapture.Movie;
import com.hammurapi.jcapture.RecordingControlsFrame;
import com.hammurapi.jcapture.ShapeImpl;
import com.hammurapi.jcapture.VideoEncoder;
import com.hammurapi.jcapture.WavFile;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Executor;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class MovieEditorDialog
extends JDialog {
    private static final double DECIBELS_PER_PIXEL = 2.0;
    private static final double NORMALIZED_LEVEL = 0.95;
    private static final int AUDIO_CELL_HEIGHT = 50;
    private static final int MEDIAN = 25;
    int minCellDimension = 10;
    int minToolTipImageDimension = 150;
    int splashIndex = -1;
    double coeff;
    private static Color INACTIVE_COLOR = new Color(230, 230, 230);
    private static Color ACTIVE_COLOR = Color.white;
    private static Color SELECTED_COLOR = new Color(0, 0, 255, 70);
    private static Color FOCUSED_COLOR = new Color(0, 0, 255, 100);
    private static Color PLAYING_COLOR = new Color(255, 0, 0, 100);
    private static Color SPLASH_COLOR = new Color(0, 255, 0, 127);
    private static Color SOUND_COLOR = new Color(0, 0, 127);
    private static Color DELETED_SOUND_COLOR = new Color(100, 100, 100);
    private JButton saveButton;
    private JPanel contentPanel;
    private JScrollPane timeLineScrollPane;
    private JCheckBox normalizeVolumeCheckBox;
    private JPanel frameCanvas;
    JTable timeLineTable;
    private JButton discardButton;
    private int focusColumn = 0;
    private int playingColumn = -1;
    private Image mouseImage;
    private double maxVolume = -1.0;
    FrameEntry[] frameEntries;
    int cellWidth;
    int cellHeight;
    int toolTipImageWidth;
    int toolTipImageHeight;
    boolean hasAudio;
    private Movie movie;
    int numChannels;
    int validBits;
    long sampleRate;
    Timer[] playTimera = new Timer[]{null};
    private Executor backgroundProcessor;
    private double inactivityInterval;
    private String imageFormat;

    public MovieEditorDialog(final JFrame frame, final Movie movie, Executor backgroundProcessor, double inactivityInterval, String imageFormat) {
        super((Frame)frame, "Movie editor (" + movie + ")");
        frame.setAlwaysOnTop(false);
        frame.setVisible(false);
        this.movie = movie;
        this.backgroundProcessor = backgroundProcessor;
        this.inactivityInterval = inactivityInterval;
        this.imageFormat = imageFormat;
        this.setModal(true);
        this.setIconImage(frame.getIconImage());
        this.mouseImage = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("mouse.png"));
        double aspectRatio = movie.getFrameDimension().getWidth() / movie.getFrameDimension().getHeight();
        if (aspectRatio > 1.0) {
            this.cellHeight = this.minCellDimension;
            this.cellWidth = (int)Math.round(aspectRatio * (double)this.cellHeight);
            this.toolTipImageHeight = this.minToolTipImageDimension;
            this.toolTipImageWidth = (int)Math.round(aspectRatio * (double)this.toolTipImageHeight);
        } else {
            this.cellWidth = this.minCellDimension;
            this.cellHeight = (int)Math.round((double)this.cellWidth / aspectRatio);
            this.toolTipImageWidth = this.minToolTipImageDimension;
            this.toolTipImageHeight = (int)Math.round((double)this.toolTipImageWidth / aspectRatio);
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                int confirmed = JOptionPane.showConfirmDialog(null, "Are you sure you want to exit and discard the movie?", "User Confirmation", 0);
                if (confirmed == 0) {
                    MovieEditorDialog.this.dispose();
                    MovieEditorDialog.this.getOwner().setVisible(false);
                }
            }
        });
        SwingWorker<Boolean, Long> loader = new SwingWorker<Boolean, Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Boolean doInBackground() throws Exception {
                int totalFrames = 0;
                for (VideoEncoder.Fragment fr : movie.getFragments()) {
                    if (fr.getAudio() != null) {
                        MovieEditorDialog.this.hasAudio = true;
                    }
                    totalFrames += fr.getFrames().size();
                }
                ProgressMonitor progressMonitor = new ProgressMonitor(frame, "Loading frames", "Loading movie frames", 0, totalFrames);
                try {
                    MovieEditorDialog.this.frameEntries = new FrameEntry[totalFrames];
                    int idx = 0;
                    double audioSamplesPerFrame = -1.0;
                    Point prevMouse = null;
                    for (VideoEncoder.Fragment fr : movie.getFragments()) {
                        WavFile wavFile;
                        WavFile wavFile2 = wavFile = fr.getAudio() == null ? null : WavFile.openWavFile(fr.getAudio());
                        if (wavFile != null) {
                            audioSamplesPerFrame = (float)wavFile.getSampleRate() / movie.getFramesPerSecond();
                            MovieEditorDialog.this.numChannels = wavFile.getNumChannels();
                            MovieEditorDialog.this.validBits = wavFile.getValidBits();
                            MovieEditorDialog.this.sampleRate = wavFile.getSampleRate();
                        }
                        int audioFramesRead = 0;
                        int framePosition = 0;
                        for (VideoEncoder.Fragment.Frame frm : fr.getFrames()) {
                            if (progressMonitor.isCanceled()) {
                                Boolean bl = false;
                                return bl;
                            }
                            MovieEditorDialog.this.frameEntries[idx] = new FrameEntry();
                            MovieEditorDialog.this.frameEntries[idx].frame = frm;
                            MovieEditorDialog.this.frameEntries[idx].idx = idx;
                            if (frm.getMousePointer() != null) {
                                MovieEditorDialog.this.frameEntries[idx].mouseMoved = !frm.getMousePointer().equals(prevMouse);
                            }
                            prevMouse = frm.getMousePointer();
                            if (framePosition == 0) {
                                MovieEditorDialog.this.frameEntries[idx].audioFile = fr.getAudio();
                            }
                            if (wavFile != null && wavFile.getFramesRemaining() > 0L) {
                                MovieEditorDialog.this.frameEntries[idx].audioSamplesInFrame = (int)((double)(framePosition + 1) * audioSamplesPerFrame - (double)audioFramesRead);
                                MovieEditorDialog.this.frameEntries[idx].audioSamples = new double[MovieEditorDialog.this.cellWidth];
                                double[][] sampleBuffer = new double[wavFile.getNumChannels()][MovieEditorDialog.this.frameEntries[idx].audioSamplesInFrame];
                                MovieEditorDialog.this.frameEntries[idx].audioSamplesInFrame = wavFile.readFrames(sampleBuffer, MovieEditorDialog.this.frameEntries[idx].audioSamplesInFrame);
                                audioFramesRead += MovieEditorDialog.this.frameEntries[idx].audioSamplesInFrame;
                                for (int i = 0; i < MovieEditorDialog.this.frameEntries[idx].audioSamplesInFrame; ++i) {
                                    for (int ch = 0; ch < wavFile.getNumChannels(); ++ch) {
                                        MovieEditorDialog.this.maxVolume = Math.max(MovieEditorDialog.this.maxVolume, Math.abs(sampleBuffer[ch][i]));
                                        int asidx = i * MovieEditorDialog.this.cellWidth / MovieEditorDialog.this.frameEntries[idx].audioSamplesInFrame;
                                        MovieEditorDialog.this.frameEntries[idx].audioSamples[asidx] = Math.max(Math.abs(sampleBuffer[ch][i]), MovieEditorDialog.this.frameEntries[idx].audioSamples[asidx]);
                                    }
                                }
                            }
                            ++framePosition;
                            progressMonitor.setProgress(++idx);
                        }
                        if (wavFile == null) continue;
                        wavFile.close();
                    }
                    MovieEditorDialog.this.coeff = Math.pow(10.0, 2.4) / MovieEditorDialog.this.maxVolume;
                    Boolean bl = true;
                    return bl;
                }
                finally {
                    progressMonitor.close();
                }
            }

            @Override
            protected void done() {
                try {
                    if (((Boolean)this.get()).booleanValue()) {
                        MovieEditorDialog.this.buildUI();
                        MovieEditorDialog.this.setLocationRelativeTo(frame);
                        MovieEditorDialog.this.setVisible(true);
                    } else {
                        JOptionPane.showMessageDialog(MovieEditorDialog.this, "Loading operation was cancelled", "Loading cancelled", 0);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(MovieEditorDialog.this, e.toString(), "Error loading frames", 0);
                }
            }
        };
        loader.execute();
    }

    void buildUI() {
        BorderLayout thisLayout = new BorderLayout();
        this.getContentPane().setLayout(thisLayout);
        this.contentPanel = new JPanel();
        GridBagLayout contentPanelLayout = new GridBagLayout();
        this.getContentPane().add((Component)this.contentPanel, "Center");
        contentPanelLayout.rowWeights = new double[]{0.1, 0.0, 0.0, 0.0, 0.0, 0.0};
        contentPanelLayout.rowHeights = new int[]{this.movie.getFrameDimension().height, 7, this.cellHeight + (this.hasAudio ? 73 : 22), 7, 7, 7};
        contentPanelLayout.columnWeights = new double[]{0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        contentPanelLayout.columnWidths = new int[]{7, 7, 7, 7, 7, 7, 7};
        this.contentPanel.setLayout(contentPanelLayout);
        this.saveButton = new JButton("Save");
        this.contentPanel.add((Component)this.saveButton, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SwingWorker<Movie, Long> encoder = new SwingWorker<Movie, Long>(){

                    @Override
                    protected Movie doInBackground() throws Exception {
                        ProgressMonitor progressMonitor = new ProgressMonitor(MovieEditorDialog.this, "Saving movie", "Composing movie", 0, MovieEditorDialog.this.frameEntries.length);
                        ArrayList<VideoEncoder.Fragment.Frame> newFrames = new ArrayList<VideoEncoder.Fragment.Frame>();
                        if (MovieEditorDialog.this.splashIndex != -1) {
                            newFrames.add(new FrameImpl(Collections.singletonList(new ShapeImpl(new Point(0, 0), new ShapeImpl.ImageImpl(new MappedImage(MovieEditorDialog.this.frameEntries[MovieEditorDialog.this.splashIndex].getImage(), MovieEditorDialog.this.imageFormat, null), true))), MovieEditorDialog.this.frameEntries[MovieEditorDialog.this.splashIndex].frame.getMousePointer(), MovieEditorDialog.this.frameEntries[MovieEditorDialog.this.splashIndex].frame.getSize(), false));
                        }
                        File newAudio = MovieEditorDialog.this.hasAudio ? File.createTempFile("jCaptureAudioSink", ".wav") : null;
                        long numFrames = 0L;
                        for (FrameEntry fe : MovieEditorDialog.this.frameEntries) {
                            if (fe.isDeleted) continue;
                            numFrames += (long)fe.audioSamplesInFrame;
                        }
                        WavFile newWavFile = newAudio == null ? null : WavFile.newWavFile(newAudio, MovieEditorDialog.this.numChannels, numFrames, MovieEditorDialog.this.validBits, MovieEditorDialog.this.sampleRate);
                        File currentAudio = null;
                        WavFile currentWav = null;
                        for (int i = 0; i < MovieEditorDialog.this.frameEntries.length; ++i) {
                            if (MovieEditorDialog.this.frameEntries[i].audioFile != null) {
                                if (currentWav != null) {
                                    currentWav.close();
                                }
                                if (currentAudio != null && !currentAudio.delete()) {
                                    currentAudio.deleteOnExit();
                                }
                                currentAudio = MovieEditorDialog.this.frameEntries[i].audioFile;
                                currentWav = WavFile.openWavFile(currentAudio);
                            }
                            if (currentWav != null) {
                                int read;
                                Object buf;
                                if (MovieEditorDialog.this.normalizeVolumeCheckBox.isSelected()) {
                                    buf = new double[MovieEditorDialog.this.numChannels][MovieEditorDialog.this.frameEntries[i].audioSamplesInFrame];
                                    read = currentWav.readFrames((double[][])buf, MovieEditorDialog.this.frameEntries[i].audioSamplesInFrame);
                                    if (read > 0 && !MovieEditorDialog.this.frameEntries[i].isDeleted) {
                                        for (double[] ch : buf) {
                                            for (int j = 0; j < ch.length; ++j) {
                                                ch[j] = ch[j] * 0.95 / MovieEditorDialog.this.maxVolume;
                                            }
                                        }
                                        newWavFile.writeFrames((double[][])buf, read);
                                    }
                                } else {
                                    buf = new long[MovieEditorDialog.this.numChannels][MovieEditorDialog.this.frameEntries[i].audioSamplesInFrame];
                                    read = currentWav.readFrames((long[][])buf, MovieEditorDialog.this.frameEntries[i].audioSamplesInFrame);
                                    if (read > 0 && !MovieEditorDialog.this.frameEntries[i].isDeleted) {
                                        newWavFile.writeFrames((long[][])buf, read);
                                    }
                                }
                            }
                            if (MovieEditorDialog.this.frameEntries[i].isDeleted) {
                                if (i < MovieEditorDialog.this.frameEntries.length - 1) {
                                    ((FrameImpl)MovieEditorDialog.this.frameEntries[i + 1].frame).merge(MovieEditorDialog.this.frameEntries[i].frame);
                                }
                            } else {
                                newFrames.add(MovieEditorDialog.this.frameEntries[i].frame);
                            }
                            progressMonitor.setProgress(i);
                            if (!progressMonitor.isCanceled()) continue;
                            if (currentWav != null) {
                                currentWav.close();
                            }
                            if (currentAudio != null && !currentAudio.delete()) {
                                currentAudio.deleteOnExit();
                            }
                            if (newWavFile != null) {
                                newWavFile.close();
                            }
                            if (newAudio != null && !newAudio.delete()) {
                                newAudio.deleteOnExit();
                            }
                            return null;
                        }
                        if (currentWav != null) {
                            currentWav.close();
                        }
                        if (currentAudio != null && !currentAudio.delete()) {
                            currentAudio.deleteOnExit();
                        }
                        if (newWavFile != null) {
                            newWavFile.close();
                        }
                        return new Movie(MovieEditorDialog.this.movie.getFrameDimension(), MovieEditorDialog.this.movie.getFramesPerSecond(), Collections.singletonList(new FragmentImpl(newFrames, newAudio)), MovieEditorDialog.this.movie);
                    }

                    @Override
                    protected void done() {
                        try {
                            MovieEditorDialog.this.setVisible(false);
                            ((RecordingControlsFrame)MovieEditorDialog.this.getOwner()).uploadMovie((Movie)this.get());
                            MovieEditorDialog.this.dispose();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            JOptionPane.showMessageDialog(MovieEditorDialog.this, e.toString(), "Error saving recording", 0);
                            MovieEditorDialog.this.setVisible(false);
                            MovieEditorDialog.this.getOwner().setVisible(false);
                        }
                    }
                };
                encoder.execute();
            }
        });
        this.discardButton = new JButton("Discard");
        this.contentPanel.add((Component)this.discardButton, new GridBagConstraints(5, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.discardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (JOptionPane.showConfirmDialog(MovieEditorDialog.this, "Are you sure you want to discard the recording?", "Confirm discarding movie", 0) == 0) {
                    MovieEditorDialog.this.setVisible(false);
                    MovieEditorDialog.this.dispose();
                    MovieEditorDialog.this.getOwner().setVisible(false);
                }
            }
        });
        this.timeLineScrollPane = new JScrollPane();
        this.timeLineScrollPane.setPreferredSize(new Dimension(this.movie.getFrameDimension().width, this.cellHeight + (this.hasAudio ? 73 : 22)));
        this.contentPanel.add((Component)this.timeLineScrollPane, new GridBagConstraints(0, 2, 7, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        System.out.println("Loaded " + this.frameEntries.length + " frames");
        DefaultTableModel timeLineTableModel = new DefaultTableModel(this.hasAudio ? 2 : 1, this.frameEntries.length){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.timeLineTable = new JTable(){

            @Override
            public JToolTip createToolTip() {
                Point p = this.getMousePosition();
                int hitColumnIndex = this.columnAtPoint(p);
                int hitRowIndex = this.rowAtPoint(p);
                if (hitColumnIndex != -1 && hitRowIndex != -1) {
                    try {
                        BufferedImage toolTipImage = MovieEditorDialog.this.frameEntries[hitColumnIndex].getToolTipImage();
                        return new ImageToolTip("Frame " + (hitColumnIndex + 1) + ", delta " + MovieEditorDialog.this.frameEntries[hitColumnIndex].delta + "%", toolTipImage);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return super.createToolTip();
            }
        };
        JPopupMenu popup = new JPopupMenu("Context");
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                if (MovieEditorDialog.this.playTimera[0] != null) {
                    MovieEditorDialog.this.playTimera[0].stop();
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.addDeleteFramesMenuItem(popup);
        this.addUndeleteFramesMenuItem(popup);
        this.addRemoveInactivityMenuItem(popup);
        final JCheckBoxMenuItem splashMenuItem = new JCheckBoxMenuItem("Splash");
        splashMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieEditorDialog.this.splashIndex = splashMenuItem.isSelected() ? MovieEditorDialog.this.focusColumn : -1;
                MovieEditorDialog.this.timeLineTable.repaint();
            }
        });
        popup.add(splashMenuItem);
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                splashMenuItem.setSelected(MovieEditorDialog.this.focusColumn != -1 && MovieEditorDialog.this.focusColumn == MovieEditorDialog.this.splashIndex);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        JMenuItem playMenuItem = new JMenuItem();
        AbstractAction playAction = new AbstractAction("Play"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                if (MovieEditorDialog.this.playTimera[0] != null) {
                    MovieEditorDialog.this.playTimera[0].stop();
                    MovieEditorDialog.this.playTimera[0] = null;
                }
                final int[] range = new int[]{MovieEditorDialog.this.focusColumn, MovieEditorDialog.this.focusColumn};
                int i = MovieEditorDialog.this.focusColumn;
                while (i < MovieEditorDialog.this.frameEntries.length && MovieEditorDialog.this.timeLineTable.isColumnSelected(i)) {
                    range[1] = i++;
                }
                i = MovieEditorDialog.this.focusColumn;
                while (i >= 0 && MovieEditorDialog.this.timeLineTable.isColumnSelected(i)) {
                    range[0] = i--;
                }
                if (range[0] == range[1]) {
                    range[1] = MovieEditorDialog.this.frameEntries.length - 1;
                }
                MovieEditorDialog.this.playingColumn = range[0];
                if (MovieEditorDialog.this.hasAudio) {
                    try {
                        MovieEditorDialog.this.backgroundProcessor.execute(new SoundPlayer(range[0], range[1]));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(MovieEditorDialog.this, ex.toString(), "Audio problem", 0);
                    }
                }
                MovieEditorDialog.this.playTimera[0] = new Timer((int)(1000.0 / (double)MovieEditorDialog.this.movie.getFramesPerSecond()), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Rectangle playingRect;
                        while (MovieEditorDialog.this.frameEntries[((MovieEditorDialog)MovieEditorDialog.this).playingColumn].isDeleted) {
                            ++MovieEditorDialog.this.playingColumn;
                            if (MovieEditorDialog.this.playingColumn <= range[1]) continue;
                            ((Timer)e.getSource()).stop();
                            return;
                        }
                        Rectangle visibleRect = MovieEditorDialog.this.timeLineTable.getVisibleRect();
                        if (!visibleRect.contains(playingRect = MovieEditorDialog.this.timeLineTable.getCellRect(0, MovieEditorDialog.this.playingColumn, true))) {
                            Rectangle scrollTo = new Rectangle(playingRect.x, playingRect.width, visibleRect.width - 1, visibleRect.height - 1);
                            MovieEditorDialog.this.timeLineTable.scrollRectToVisible(scrollTo);
                        }
                        MovieEditorDialog.this.frameCanvas.repaint();
                        MovieEditorDialog.this.timeLineTable.repaint();
                        ++MovieEditorDialog.this.playingColumn;
                        if (MovieEditorDialog.this.playingColumn > range[1]) {
                            ((Timer)e.getSource()).stop();
                            return;
                        }
                    }
                }){

                    @Override
                    public void stop() {
                        super.stop();
                        MovieEditorDialog.this.playingColumn = -1;
                        MovieEditorDialog.this.timeLineTable.scrollRectToVisible(MovieEditorDialog.this.timeLineTable.getCellRect(0, MovieEditorDialog.this.focusColumn, true));
                        MovieEditorDialog.this.frameCanvas.repaint();
                        MovieEditorDialog.this.timeLineTable.repaint();
                        MovieEditorDialog.this.playTimera[0] = null;
                    }
                };
                MovieEditorDialog.this.playTimera[0].start();
                Timer[] timerArray = MovieEditorDialog.this.playTimera;
                synchronized (MovieEditorDialog.this.playTimera) {
                    MovieEditorDialog.this.playTimera.notifyAll();
                    // ** MonitorExit[var3_5] (shouldn't be in output)
                    return;
                }
            }
        };
        playMenuItem.setAction(playAction);
        popup.add(playMenuItem);
        this.timeLineTable.setComponentPopupMenu(popup);
        this.timeLineTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int hitColumnIndex;
                if (MovieEditorDialog.this.playTimera[0] != null) {
                    MovieEditorDialog.this.playTimera[0].stop();
                }
                if (e.getClickCount() == 2 && (hitColumnIndex = MovieEditorDialog.this.timeLineTable.columnAtPoint(e.getPoint())) != -1) {
                    MovieEditorDialog.this.frameEntries[hitColumnIndex].isDeleted = !MovieEditorDialog.this.frameEntries[hitColumnIndex].isDeleted;
                    MovieEditorDialog.this.timeLineTable.repaint();
                }
            }
        });
        this.timeLineTable.setToolTipText("Movie timeline");
        this.timeLineScrollPane.setViewportView(this.timeLineTable);
        this.timeLineTable.setModel(timeLineTableModel);
        this.timeLineTable.setRowHeight(0, this.cellHeight + this.timeLineTable.getRowMargin() * 2);
        this.timeLineTable.setRowHeight(1, 50 + this.timeLineTable.getRowMargin() * 2);
        for (int i = 0; i < this.frameEntries.length; ++i) {
            this.timeLineTable.getColumnModel().getColumn(i).setPreferredWidth(this.cellWidth);
            this.timeLineTable.setValueAt(this.frameEntries[i], 0, i);
            if (!this.hasAudio) continue;
            this.timeLineTable.setValueAt(this.frameEntries[i], 1, i);
        }
        this.timeLineTable.setAutoResizeMode(0);
        this.timeLineTable.setTableHeader(null);
        this.timeLineTable.getSelectionModel().setSelectionMode(2);
        this.timeLineTable.setColumnSelectionAllowed(true);
        this.timeLineTable.setRowSelectionAllowed(false);
        TableCellRenderer renderer = new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (hasFocus && column != MovieEditorDialog.this.focusColumn) {
                    MovieEditorDialog.this.focusColumn = column;
                    MovieEditorDialog.this.frameCanvas.repaint();
                }
                return MovieEditorDialog.this.frameEntries[column].getCellRendererComponent(row, isSelected, hasFocus);
            }
        };
        this.timeLineTable.setDefaultRenderer(Object.class, renderer);
        this.frameCanvas = new JPanel(){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                Rectangle bounds = this.getBounds();
                try {
                    BufferedImage image = MovieEditorDialog.this.frameEntries[MovieEditorDialog.this.playingColumn == -1 ? MovieEditorDialog.this.focusColumn : MovieEditorDialog.this.playingColumn].getImage();
                    double xScale = (double)bounds.width / (double)((Image)image).getWidth(null);
                    double yScale = (double)bounds.height / (double)((Image)image).getHeight(null);
                    double scale = Math.min(xScale, yScale);
                    int scaledWidth = (int)((double)((Image)image).getWidth(null) * scale);
                    int scaledHeight = (int)((double)((Image)image).getHeight(null) * scale);
                    if (g instanceof Graphics2D) {
                        ((Graphics2D)g).setComposite(AlphaComposite.Src);
                        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    }
                    g.drawImage(image, (bounds.width - scaledWidth) / 2, (bounds.height - scaledHeight) / 2, scaledWidth, scaledHeight, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    g.clearRect(0, 0, bounds.width, bounds.height);
                    g.drawString(e.toString(), 10, 20);
                }
            }
        };
        this.frameCanvas.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MovieEditorDialog.this.playTimera[0] != null) {
                    MovieEditorDialog.this.playTimera[0].stop();
                }
            }
        });
        this.frameCanvas.setPreferredSize(this.movie.getFrameDimension());
        this.contentPanel.add((Component)this.frameCanvas, new GridBagConstraints(0, 0, 7, 1, 0.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.normalizeVolumeCheckBox = new JCheckBox();
        this.contentPanel.add((Component)this.normalizeVolumeCheckBox, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.normalizeVolumeCheckBox.setText("Normalize volume (+" + Math.round(Math.log10(0.95 / this.maxVolume) * 20.0) + " dB)");
        this.timeLineTable.changeSelection(0, 0, false, false);
        this.frameCanvas.repaint();
        this.pack();
    }

    void addUndeleteFramesMenuItem(JPopupMenu popup) {
        JMenuItem unDeleteFrameMenuItem = new JMenuItem();
        AbstractAction unDeleteFrameAction = new AbstractAction("Undelete frame(s)"){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int idx : MovieEditorDialog.this.timeLineTable.getSelectedColumns()) {
                    MovieEditorDialog.this.frameEntries[idx].isDeleted = false;
                }
                MovieEditorDialog.this.timeLineTable.repaint();
            }
        };
        unDeleteFrameMenuItem.setAction(unDeleteFrameAction);
        popup.add(unDeleteFrameMenuItem);
    }

    void addDeleteFramesMenuItem(JPopupMenu popup) {
        JMenuItem deleteFrameMenuItem = new JMenuItem();
        AbstractAction deleteFrameAction = new AbstractAction("Delete frame(s)"){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int idx : MovieEditorDialog.this.timeLineTable.getSelectedColumns()) {
                    MovieEditorDialog.this.frameEntries[idx].isDeleted = true;
                }
                MovieEditorDialog.this.timeLineTable.repaint();
            }
        };
        deleteFrameMenuItem.setAction(deleteFrameAction);
        popup.add(deleteFrameMenuItem);
    }

    void addRemoveInactivityMenuItem(JPopupMenu popup) {
        JMenuItem removeInactivityMenuItem = new JMenuItem();
        AbstractAction deleteFrameAction = new AbstractAction("Remove inactivity"){

            @Override
            public void actionPerformed(ActionEvent e) {
                String msg = "Inactivity interval";
                while (true) {
                    String newVal;
                    if ((newVal = JOptionPane.showInputDialog(msg, (Object)String.valueOf(MovieEditorDialog.this.inactivityInterval))) == null) {
                        return;
                    }
                    try {
                        MovieEditorDialog.this.inactivityInterval = Double.parseDouble(newVal);
                        if (MovieEditorDialog.this.inactivityInterval > 0.0) {
                            break;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    msg = "Invalid double value for inactivity interval: " + newVal + ", enter valid value";
                }
                int inactivityInFrames = (int)(MovieEditorDialog.this.inactivityInterval * (double)MovieEditorDialog.this.movie.getFramesPerSecond());
                int lastActivity = -inactivityInFrames - 1;
                for (int idx : MovieEditorDialog.this.timeLineTable.getSelectedColumns()) {
                    if (!MovieEditorDialog.this.frameEntries[idx].isDeleted && MovieEditorDialog.this.frameEntries[idx].frame.isActive()) {
                        lastActivity = idx;
                        continue;
                    }
                    if (idx - lastActivity <= inactivityInFrames || MovieEditorDialog.this.frameEntries[idx].frame.isActive()) continue;
                    MovieEditorDialog.this.frameEntries[idx].isDeleted = true;
                }
                MovieEditorDialog.this.timeLineTable.repaint();
            }
        };
        removeInactivityMenuItem.setAction(deleteFrameAction);
        popup.add(removeInactivityMenuItem);
    }

    private class SoundPlayer
    implements Runnable {
        private final int BUFFER_SIZE;
        private AudioInputStream audioStream;
        private SourceDataLine sourceLine;
        private File audioFile;

        public SoundPlayer(int start, int end) throws Exception {
            this.audioFile = MovieEditorDialog.this.hasAudio ? File.createTempFile("jCaptureRangeAudio", ".wav") : null;
            this.BUFFER_SIZE = (int)((double)MovieEditorDialog.this.numChannels * (double)MovieEditorDialog.this.sampleRate * (double)MovieEditorDialog.this.validBits / (double)(MovieEditorDialog.this.movie.getFramesPerSecond() * 8.0f));
            long numFrames = 0L;
            for (int i = start; i <= end; ++i) {
                if (MovieEditorDialog.this.frameEntries[i].isDeleted) continue;
                numFrames += (long)MovieEditorDialog.this.frameEntries[i].audioSamplesInFrame;
            }
            WavFile newWavFile = this.audioFile == null ? null : WavFile.newWavFile(this.audioFile, MovieEditorDialog.this.numChannels, numFrames, MovieEditorDialog.this.validBits, MovieEditorDialog.this.sampleRate);
            File currentAudio = null;
            WavFile currentWav = null;
            for (int i = 0; i <= end; ++i) {
                int read;
                Object buf;
                if (MovieEditorDialog.this.frameEntries[i].audioFile != null) {
                    if (currentWav != null) {
                        currentWav.close();
                    }
                    currentAudio = MovieEditorDialog.this.frameEntries[i].audioFile;
                    currentWav = WavFile.openWavFile(currentAudio);
                }
                if (currentWav == null) continue;
                if (MovieEditorDialog.this.normalizeVolumeCheckBox != null && MovieEditorDialog.this.normalizeVolumeCheckBox.isSelected()) {
                    buf = new double[MovieEditorDialog.this.numChannels][MovieEditorDialog.this.frameEntries[i].audioSamplesInFrame];
                    read = currentWav.readFrames((double[][])buf, MovieEditorDialog.this.frameEntries[i].audioSamplesInFrame);
                    if (read <= 0 || i < start || MovieEditorDialog.this.frameEntries[i].isDeleted) continue;
                    for (long[] ch : buf) {
                        for (int j = 0; j < ch.length; ++j) {
                            ch[j] = ch[j] * 0.95 / MovieEditorDialog.this.maxVolume;
                        }
                    }
                    newWavFile.writeFrames((double[][])buf, read);
                    continue;
                }
                buf = new long[MovieEditorDialog.this.numChannels][MovieEditorDialog.this.frameEntries[i].audioSamplesInFrame];
                read = currentWav.readFrames((long[][])buf, MovieEditorDialog.this.frameEntries[i].audioSamplesInFrame);
                if (read <= 0 || i < start || MovieEditorDialog.this.frameEntries[i].isDeleted) continue;
                newWavFile.writeFrames((long[][])buf, read);
            }
            if (currentWav != null) {
                currentWav.close();
            }
            if (newWavFile != null) {
                newWavFile.close();
            }
            if (this.audioFile != null) {
                this.audioStream = AudioSystem.getAudioInputStream(this.audioFile);
                AudioFormat audioFormat = this.audioStream.getFormat();
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
                this.sourceLine = (SourceDataLine)AudioSystem.getLine(info);
                this.sourceLine.open(audioFormat);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.sourceLine.start();
                Timer[] timerArray = MovieEditorDialog.this.playTimera;
                synchronized (MovieEditorDialog.this.playTimera) {
                    if (MovieEditorDialog.this.playTimera[0] == null) {
                        MovieEditorDialog.this.playTimera.wait(100L);
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    try {
                        int l;
                        byte[] buf = new byte[this.BUFFER_SIZE];
                        while (MovieEditorDialog.this.playTimera[0] != null && (l = this.audioStream.read(buf)) != -1) {
                            this.sourceLine.write(buf, 0, l);
                        }
                    }
                    finally {
                        this.audioStream.close();
                        this.sourceLine.drain();
                        this.sourceLine.close();
                        if (!this.audioFile.delete()) {
                            this.audioFile.deleteOnExit();
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            {
                return;
            }
        }
    }

    private class FrameEntry {
        File audioFile;
        boolean mouseMoved;
        double[] audioSamples;
        int audioSamplesInFrame;
        boolean isDeleted;
        Reference<BufferedImage> toolTipImageRef;
        Reference<BufferedImage> frameImageRef;
        private JPanel[][][] canvases = new JPanel[][][]{{{new FrameCellCanvas(false, false), new FrameCellCanvas(false, true)}, {new FrameCellCanvas(true, false), new FrameCellCanvas(true, true)}}, {{new AudioCellCanvas(false, false), new AudioCellCanvas(false, true)}, {new AudioCellCanvas(true, false), new AudioCellCanvas(true, true)}}};
        int idx;
        int delta;
        VideoEncoder.Fragment.Frame frame;

        private FrameEntry() {
        }

        BufferedImage getToolTipImage() throws IOException {
            BufferedImage ret;
            BufferedImage bufferedImage = ret = this.toolTipImageRef == null ? null : this.toolTipImageRef.get();
            if (ret == null) {
                BufferedImage image = this.getImage();
                ret = new BufferedImage(MovieEditorDialog.this.toolTipImageWidth, MovieEditorDialog.this.toolTipImageHeight, image.getType());
                Graphics2D g = ret.createGraphics();
                g.setComposite(AlphaComposite.Src);
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.drawImage(image, 0, 0, ret.getWidth(), ret.getHeight(), null);
                g.dispose();
                this.toolTipImageRef = new SoftReference<BufferedImage>(ret);
            }
            return ret;
        }

        void paintFrame(FrameCellCanvas frameCellCanvas, Graphics g, boolean selected, boolean hasFocus) {
            g.setColor(this.frame.isActive() ? ACTIVE_COLOR : INACTIVE_COLOR);
            g.fillRect(0, 0, frameCellCanvas.getWidth(), frameCellCanvas.getHeight());
            if (this.idx == MovieEditorDialog.this.splashIndex) {
                g.setColor(SPLASH_COLOR);
                g.fillRect(1, 1, frameCellCanvas.getWidth() - 2, frameCellCanvas.getHeight() - 2);
            }
            if (this.frame.getMousePointer() != null) {
                int mx = (int)(this.frame.getMousePointer().getX() * (double)(frameCellCanvas.getWidth() - 3) / this.frame.getSize().getWidth()) + 1;
                int my = (int)(this.frame.getMousePointer().getY() * (double)(frameCellCanvas.getHeight() - 3) / this.frame.getSize().getHeight()) + 1;
                g.setColor(this.mouseMoved ? Color.BLACK : Color.GRAY);
                g.fillRect(mx, my, 2, 2);
            }
            if (this.isDeleted) {
                g.setColor(Color.RED);
                g.drawLine(2, 2, frameCellCanvas.getWidth() - 2, frameCellCanvas.getHeight() - 2);
                g.drawLine(frameCellCanvas.getWidth() - 2, 2, 2, frameCellCanvas.getHeight() - 2);
            }
            this.decorate(frameCellCanvas, g, selected, hasFocus);
        }

        void paintAudio(AudioCellCanvas audioCellCanvas, Graphics g, boolean selected, boolean hasFocus) {
            g.setColor(this.frame.isActive() ? ACTIVE_COLOR : INACTIVE_COLOR);
            g.fillRect(0, 0, audioCellCanvas.getWidth(), audioCellCanvas.getHeight());
            if (this.audioSamples != null) {
                for (int i = 0; i < audioCellCanvas.getWidth(); ++i) {
                    g.setColor(this.isDeleted ? DELETED_SOUND_COLOR : SOUND_COLOR);
                    int volume = (int)(20.0 * Math.log10(MovieEditorDialog.this.coeff * this.audioSamples[Math.min(i, this.audioSamples.length - 1)] + 1.0) / 2.0);
                    g.drawLine(i, 25 - volume, i, 25 + volume);
                }
            }
            this.decorate(audioCellCanvas, g, selected, hasFocus);
        }

        private void decorate(JComponent component, Graphics g, boolean selected, boolean hasFocus) {
            if (this.idx == MovieEditorDialog.this.playingColumn) {
                g.setColor(PLAYING_COLOR);
                Rectangle bounds = g.getClipBounds();
                g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            } else if (hasFocus) {
                g.setColor(FOCUSED_COLOR);
                Rectangle bounds = g.getClipBounds();
                g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            } else if (selected) {
                g.setColor(SELECTED_COLOR);
                Rectangle bounds = g.getClipBounds();
                g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            }
        }

        BufferedImage getImage() throws IOException {
            BufferedImage ret;
            BufferedImage bufferedImage = ret = this.frameImageRef == null ? null : this.frameImageRef.get();
            if (ret == null) {
                int startIdx;
                for (startIdx = this.idx; startIdx > 0 && !this.coversEverything(startIdx); --startIdx) {
                }
                int deltaArea = 0;
                ret = new BufferedImage(this.frame.getSize().width, this.frame.getSize().height, this.shapeImage(MovieEditorDialog.this.frameEntries[startIdx].frame.getShapes().get(0)).getType());
                Graphics2D g = ret.createGraphics();
                for (int i = startIdx; i <= this.idx; ++i) {
                    for (VideoEncoder.Fragment.Frame.Shape shape : MovieEditorDialog.this.frameEntries[i].frame.getShapes()) {
                        BufferedImage si = this.shapeImage(shape);
                        g.drawImage((Image)si, shape.getLocation().x, shape.getLocation().y, null);
                        if (i != this.idx) continue;
                        deltaArea += si.getWidth() * si.getHeight();
                    }
                }
                this.delta = (int)(100.0 * (double)deltaArea / (double)(this.frame.getSize().width * this.frame.getSize().height));
                if (this.frame.getMousePointer() != null) {
                    g.drawImage(MovieEditorDialog.this.mouseImage, this.frame.getMousePointer().x, this.frame.getMousePointer().y, null);
                }
                this.frameImageRef = new SoftReference<BufferedImage>(ret);
            }
            return ret;
        }

        private BufferedImage shapeImage(VideoEncoder.Fragment.Frame.Shape shape) throws IOException {
            VideoEncoder.Fragment.Frame.Shape.ShapeContent shapeContent = shape.getContent();
            if (shapeContent instanceof VideoEncoder.Fragment.Frame.Shape.ImageReference) {
                return ((VideoEncoder.Fragment.Frame.Shape.ImageReference)shapeContent).getImage().getImage().getImage();
            }
            return ((VideoEncoder.Fragment.Frame.Shape.Image)shapeContent).getImage().getImage();
        }

        boolean coversEverything(int entryIdx) {
            for (VideoEncoder.Fragment.Frame.Shape shape : MovieEditorDialog.this.frameEntries[entryIdx].frame.getShapes()) {
                if (!shape.getContent().coversEverything()) continue;
                return true;
            }
            return false;
        }

        public Component getCellRendererComponent(int row, boolean isSelected, boolean hasFocus) {
            return this.canvases[row][isSelected ? 1 : 0][hasFocus ? 1 : 0];
        }

        class AudioCellCanvas
        extends CellCanvas {
            AudioCellCanvas(boolean selected, boolean hasFocus) {
                super(selected, hasFocus);
            }

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                FrameEntry.this.paintAudio(this, g, this.selected, this.hasFocus);
            }
        }

        class FrameCellCanvas
        extends CellCanvas {
            FrameCellCanvas(boolean selected, boolean hasFocus) {
                super(selected, hasFocus);
            }

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                FrameEntry.this.paintFrame(this, g, this.selected, this.hasFocus);
            }
        }

        class CellCanvas
        extends JPanel {
            boolean selected;
            boolean hasFocus;

            CellCanvas(boolean selected, boolean hasFocus) {
                this.selected = selected;
                this.hasFocus = hasFocus;
            }
        }
    }
}

