/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.action;

import com.flagstone.transform.action.Action;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;

public final class WaitForFrame
implements Action {
    private static final String FORMAT = "WaitForFrame: { frameNumber=%d; actionCount=%d}";
    private static final int MAX_FRAME_OFFSET = 65535;
    private static final int MAX_COUNT = 255;
    private final transient int frameNumber;
    private final transient int actionCount;

    public WaitForFrame(SWFDecoder coder) throws IOException {
        coder.readUnsignedShort();
        this.frameNumber = coder.readUnsignedShort();
        this.actionCount = coder.readByte();
    }

    public WaitForFrame(int frame, int count) {
        if (frame < 1 || frame > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, frame);
        }
        this.frameNumber = frame;
        if (count < 0 || count > 255) {
            throw new IllegalArgumentRangeException(1, 255, count);
        }
        this.actionCount = count;
    }

    public WaitForFrame(WaitForFrame object) {
        this.frameNumber = object.frameNumber;
        this.actionCount = object.actionCount;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public int getActionCount() {
        return this.actionCount;
    }

    @Override
    public WaitForFrame copy() {
        return this;
    }

    public String toString() {
        return String.format(FORMAT, this.frameNumber, this.actionCount);
    }

    @Override
    public int prepareToEncode(Context context) {
        return 6;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(138);
        coder.writeShort(3);
        coder.writeShort(this.frameNumber);
        coder.writeByte(this.actionCount);
    }
}

